'use strict';

var debugModeUrl = '';
var dataPath = 'data/';

/* App Module */
var viewer = angular.module('viewer', ['JsonModels', 'ngRoute', 'Resources']);



viewer.config(['$routeProvider', function($routeProvider) {
    $routeProvider.
        when('/index', {
            templateUrl: debugModeUrl + '/js/partials/main.html',
            resolve: {
                structure: function(StructureJson, StructureResource, $q){
                    var deferer = $q.defer();
                    StructureResource.query(function(data){
                        StructureJson.setData(data);
                        deferer.resolve(true);
                    });

                    return deferer.promise;
                }
            }
        })
        .when('/task/:pageId/:activityId', {
            templateUrl: debugModeUrl + '/js/partials/task.html',
            resolve: {
                page: function(StructureJson, PageResource, StructureResource, $q, $route){
                    var deferer = $q.defer();
                    StructureResource.query(function(data){
                        StructureJson.setData(data);

                        var page = StructureJson.getPageById($route.current.params.pageId);

                        PageResource.query({page: page['interactionsPath']}, function(data){
                            deferer.resolve(data);
                        });
                    });

                    return deferer.promise;
                }
            }
        })
        .otherwise({redirectTo: '/index'});
}]);

viewer.run(function($rootScope, $window){

    $rootScope.dataPath = dataPath;
    var myWindow = angular.element($window); // Name the variable whatever makes sense

    /**
     * Czy mamy tryb jednostronicowy, czy dwustronicowy
     * @type {boolean}
     */
    $rootScope.forceOnePage = $window.innerWidth < $window.innerHeight;

    /**
     * Maksymalna szerokość strony
     * @type {number}
     */
    $rootScope.pageWidth = $window.innerWidth / 2;

    $rootScope.pageMaxWidth = $window.innerWidth;
    $rootScope.pageMaxHeight = $window.innerHeight;

    /**
     * Czy wysuniety jest pasek nawigacji
     * @type {boolean}
     */
    $rootScope.navigationBarOpen = false;

    /**
     * Zdarzenie rozglaszające zmianę wymiarów strony (w szczególności zmianę orientacji)
     */
    myWindow.on("resize", function() {
        $rootScope.forceOnePage = $window.innerWidth < $window.innerHeight;

        $rootScope.pageMaxWidth = $window.innerWidth;
        $rootScope.pageMaxHeight = $window.innerHeight;

        $rootScope.$broadcast('Window:resize', myWindow.width());
        $rootScope.pageWidth = $window.innerWidth / 2;
        $rootScope.pageHeight = $window.innerHeight;

        $rootScope.$apply();
    });


    /**
     * Zdarzenie odpowiadające za efekt przejscia strony
     */
    $rootScope.$on('Page:beforeChange', function(e, changeData){

        if(changeData.singleView)
        {
            angular.element('.one-page').fadeOut('slow', function(){
                $rootScope.$broadcast('Page:change', changeData);
                angular.element('.one-page').fadeIn('slow');
            });
        }
        else
        {
            angular.element('.pages').fadeOut('slow', function(){
                $rootScope.$broadcast('Page:change', changeData);
                angular.element('.pages').fadeIn('slow');
            });
        }
    });

    /**
     * Zdarzenie odpowiadające za przeskok do dowolnej strony
     */
    $rootScope.$on('Page:beforeJump', function(e, page){

        if($rootScope.forceOnePage)
        {
            angular.element('.one-page').fadeOut('slow', function(){
                $rootScope.$broadcast('Page:jump', page);
                angular.element('.one-page').fadeIn('slow');
            });
        }
        else
        {
            angular.element('.pages').fadeOut('slow', function(){
                $rootScope.$broadcast('Page:jump', page);
                angular.element('.pages').fadeIn('slow');
            });
        }
    })
});


function getScale(windowWidth, windowHeight, pageWidth, pageHeight)
{
    var scaleW = windowWidth/pageWidth;
    var scaleH = windowHeight/pageHeight;

    var scale = (scaleW < scaleH) ? scaleW : scaleH;
    return scale;
}